/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CSecureEdit.h,v 1.4 1999/09/23 23:50:55 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CSecureEdit_h	// [
#define Included_CSecureEdit_h

#include "pgpClassesConfig.h"

#include "CArray.h"
#include "CSecureString.h"
#include "CEdit.h"

_PGP_BEGIN

// Class CSecureEdit

class CSecureEdit : public CEdit
{
public:
	enum
	{
		// For private communication with the parent dialog.
		WM_SECUREEDIT_EVENT	= WM_USER + 12, 

		kContentsChangedEvent	= 0, 
		kSawCapsLockKeyEvent	= 1, 
		kSawReturnKeyEvent		= 2
	};

public:
	CSecureEdit();
	CSecureEdit(HWND hWnd);
	~CSecureEdit() { }

	const CSecureString&	Contents() const {return mContents;}

	PGPBoolean	HidingTyping() const {return mHideTyping;}
	PGPUInt32	MaxSize() const {return mMaxSize;}

	void	ClearContents();
	void	SetContents(const CSecureString& newContents);

	PGPBoolean	SetHideTypingPref(PGPBoolean hideValue);
	PGPUInt32	SetMaxSizeContents(PGPUInt32 maxSize);

private:
	CSecureString		mContents;
	CArray<PGPUInt8>	mSpacesPerChar;

	PGPBoolean	mHideTyping;
	PGPUInt32	mMaxSize;
	PGPInt32	mCurCharPos;
	PGPUInt32	mCurNumSpaces;

	HHOOK	mHhookCBT;
	HHOOK	mHhookGetMessage;
	HHOOK	mHhookKeyboard;
	HHOOK	mHhookMsgFilter;

	// Utility functions.
	void	Init();

	void	FillEditBoxWithContents();
	void	FillEditBoxWithSpaces();

	PGPUInt32	SendParentEvent(PGPUInt32 event) const;

	static LRESULT CALLBACK	SecurityHookProc(INT iCode, WPARAM wParam, 
		LPARAM lParam);

	void	InstallSecurityHooks();
	void	UninstallSecurityHooks();

	// Message handlers.
	void	OnChar(char c, PGPUInt32 keyData);
	void	OnClear() { }
	BOOL	OnCommand(PGPUInt16 notifyCode, PGPUInt16 itemId, HWND ctrl);
	void	OnCopy() { }
	void	OnCut() { }
	void	OnLButtonDblClk(PGPUInt32 keyFlags, CPoint coords);
	void	OnLButtonDown(PGPUInt32 keyFlags, CPoint coords);
	void	OnKeyDown(PGPUInt32 vKey, PGPUInt32 keyData);
	void	OnKeyUp(PGPUInt32 vKey, PGPUInt32 keyData);
	void	OnMouseMove(PGPUInt32 keyFlags, CPoint coords) { }
	void	OnPaste() { }
	BOOL	OnUndo() {return FALSE;}
};

_PGP_END

#endif	// ] Included_CSecureEdit_h
